## 解题思路：

为提升回溯的计算效率，首先讲述两项前置工作： **数位之和计算** 、 **可达解分析** 。

### 数位之和计算：

设一数字 $x$ ，向下取整除法符号 $//$ ，求余符号 $\odot$ ，则有：

- $x \odot 10$ ：得到 $x$ 的个位数字；
- $x // 10$ ： 令 $x$ 的十进制数向右移动一位，即删除个位数字。

因此，可通过循环求得数位和 $s$ ，数位和计算的封装函数如下所示：

```Python []
def sums(x):
    s = 0
    while x != 0:
        s += x % 10
        x = x // 10
    return s
```

```Java []
int sums(int x)
    int s = 0;
    while(x != 0) {
        s += x % 10;
        x = x / 10;
    }
    return s;
```

```C++ []
int sums(int x)
    int s = 0;
    while(x != 0) {
        s += x % 10;
        x = x / 10;
    }
    return s;
```

由于机器人每次只能移动一格（即只能从 $x$ 运动至 $x \pm 1$），因此每次只需计算 $x$ 到 $x \pm 1$ 的**数位和增量**。本题说明 $1 \leq n,m \leq 100$ ，以下公式仅在此范围适用。

**数位和增量公式：** 设 $x$ 的数位和为 $s_x$ ，$x+1$ 的数位和为 $s_{x+1}$ ；

1. **当 $(x + 1) \odot 10 = 0$ 时：** $s_{x+1} = s_x - 8$ ，例如 $19, 20$ 的数位和分别为 $10, 2$ ；
2. **当 $(x + 1) \odot 10 \neq 0$ 时：** $s_{x+1} = s_x + 1$ ，例如 $1, 2$ 的数位和分别为 $1, 2$ 。

> 以下代码为增量公式的三元表达式写法，将整合入最终代码中。

```Python []
s_x + 1 if (x + 1) % 10 else s_x - 8
```

```Java []
(x + 1) % 10 != 0 ? s_x + 1 : s_x - 8;
```

```C++ []
(x + 1) % 10 != 0 ? s_x + 1 : s_x - 8;
```

### 可达解分析：

根据数位和增量公式得知，数位和每逢 **进位** 突变一次。根据此特点，矩阵中 **满足数位和的解** 构成的几何形状形如多个 **等腰直角三角形** ，每个三角形的直角顶点位于 $0, 10, 20, ...$ 等数位和突变的矩阵索引处  。

三角形内的解虽然都满足数位和要求，但由于机器人每步只能走一个单元格，而三角形间不一定是连通的，因此机器人不一定能到达，称之为 **不可达解** ；同理，可到达的解称为 **可达解**  *（本题求此解）* 。

> 下图展示了 $n,m = 20$ ，$cnt \in [6, 19]$ 的可达解、不可达解、非解，以及连通性的变化。其中 $k$ 对应本题的 $cnt$ 。

<![Picture1.png](https://pic.leetcode-cn.com/1603026306-OdpwLi-Picture1.png),![Picture2.png](https://pic.leetcode-cn.com/1603026306-jCBpqd-Picture2.png),![Picture3.png](https://pic.leetcode-cn.com/1603026306-aEEvfM-Picture3.png),![Picture4.png](https://pic.leetcode-cn.com/1603026306-daxIuh-Picture4.png),![Picture5.png](https://pic.leetcode-cn.com/1603026306-HAMNPH-Picture5.png),![Picture6.png](https://pic.leetcode-cn.com/1603026306-IUKeMt-Picture6.png),![Picture7.png](https://pic.leetcode-cn.com/1603026306-YxlxXI-Picture7.png),![Picture8.png](https://pic.leetcode-cn.com/1603026306-JLhUWz-Picture8.png)>

根据可达解的结构和连通性，易推出机器人可 **仅通过向右和向下移动，访问所有可达解** 。

- **三角形内部：** 全部连通，易证；
- **两三角形连通处：** 若某三角形内的解为可达解，则必与其左边或上边的三角形连通（即相交），即机器人必可从左边或上边走进此三角形。

![Picture9.png](https://pic.leetcode-cn.com/1603024999-XMpudY-Picture9.png){:align=center width=500}

## 方法一：深度优先遍历（DFS）

**深度优先搜索：** 可以理解为暴力法模拟机器人在矩阵中的所有路径。DFS 通过递归，先朝一个方向搜到底，再回溯至上个节点，沿另一个方向搜索，以此类推。

**剪枝：** 在搜索中，遇到数位和超出目标值、此元素已访问，则应立即返回，称之为 `可行性剪枝` 。

### 算法解析：

- **递归参数：** 当前元素在矩阵中的行列索引 `i` 和 `j` ，两者的数位和 `si`, `sj` 。
- **终止条件：** 当 (1) 行列索引越界 **或** (2) 数位和超出目标值 `cnt`  **或** (3) 当前元素已访问过 时，返回 $0$ ，代表不计入可达解。
- **递推工作：**
  1. **标记当前单元格** ：将索引 `(i, j)` 存入 Set `visited` 中，代表此单元格已被访问过。
  2. **搜索下一单元格：** 计算当前元素的 **下、右** 两个方向元素的数位和，并开启下层递归 。
- **回溯返回值：** 返回 `1 + 右方搜索的可达解总数 + 下方搜索的可达解总数`，代表从本单元格递归搜索的可达解总数。

<![Picture10.png](https://pic.leetcode-cn.com/1603024999-URYkbB-Picture10.png),![Picture11.png](https://pic.leetcode-cn.com/1603024999-XyKkZo-Picture11.png),![Picture12.png](https://pic.leetcode-cn.com/1603024999-eQXMnv-Picture12.png),![Picture13.png](https://pic.leetcode-cn.com/1603024999-mcujIe-Picture13.png),![Picture14.png](https://pic.leetcode-cn.com/1603024999-dXOdEJ-Picture14.png),![Picture15.png](https://pic.leetcode-cn.com/1603024999-ApTwow-Picture15.png),![Picture16.png](https://pic.leetcode-cn.com/1603024999-krgMMb-Picture16.png),![Picture17.png](https://pic.leetcode-cn.com/1603024999-JCGqrp-Picture17.png),![Picture18.png](https://pic.leetcode-cn.com/1603024999-jYYavg-Picture18.png),![Picture19.png](https://pic.leetcode-cn.com/1603024999-RRZCbl-Picture19.png),![Picture20.png](https://pic.leetcode-cn.com/1603024999-HBTzMV-Picture20.png),![Picture21.png](https://pic.leetcode-cn.com/1603024999-iYtADx-Picture21.png)>

### 代码：

> Java/C++ 代码中 `visited` 为辅助矩阵，Python 中为 Set 。

```Python []
class Solution:
    def wardrobeFinishing(self, m: int, n: int, cnt: int) -> int:
        def dfs(i, j, si, sj):
            if i >= m or j >= n or cnt < si + sj or (i, j) in visited: return 0
            visited.add((i,j))
            return 1 + dfs(i + 1, j, si + 1 if (i + 1) % 10 else si - 8, sj) + dfs(i, j + 1, si, sj + 1 if (j + 1) % 10 else sj - 8)

        visited = set()
        return dfs(0, 0, 0, 0)
```

```Java []
class Solution {
    int m, n, cnt;
    boolean[][] visited;
    public int wardrobeFinishing(int m, int n, int cnt) {
        this.m = m; this.n = n; this.cnt = cnt;
        this.visited = new boolean[m][n];
        return dfs(0, 0, 0, 0);
    }
    public int dfs(int i, int j, int si, int sj) {
        if(i >= m || j >= n || cnt < si + sj || visited[i][j]) return 0;
        visited[i][j] = true;
        return 1 + dfs(i + 1, j, (i + 1) % 10 != 0 ? si + 1 : si - 8, sj) + dfs(i, j + 1, si, (j + 1) % 10 != 0 ? sj + 1 : sj - 8);
    }
}
```

```C++ []
class Solution {
public:
    int wardrobeFinishing(int m, int n, int cnt) {
        vector<vector<bool>> visited(m, vector<bool>(n, 0));
        return dfs(0, 0, 0, 0, visited, m, n, cnt);
    }
private:
    int dfs(int i, int j, int si, int sj, vector<vector<bool>> &visited, int m, int n, int cnt) {
        if(i >= m || j >= n || cnt < si + sj || visited[i][j]) return 0;
        visited[i][j] = true;
        return 1 + dfs(i + 1, j, (i + 1) % 10 != 0 ? si + 1 : si - 8, sj, visited, m, n, cnt) +
                   dfs(i, j + 1, si, (j + 1) % 10 != 0 ? sj + 1 : sj - 8, visited, m, n, cnt);
    }
};
```

### 复杂度分析：

> 设矩阵行列数分别为 $M, N$ 。

- **时间复杂度 $O(MN)$ ：** 最差情况下，机器人遍历矩阵所有单元格，此时时间复杂度为 $O(MN)$ 。
- **空间复杂度 $O(MN)$ ：** 最差情况下，Set `visited` 内存储矩阵所有单元格的索引，使用 $O(MN)$ 的额外空间。

## 方法二：广度优先遍历（BFS）

BFS 和 DFS 的目标都是遍历整个矩阵，不同点在于搜索顺序不同。DFS 是朝一个方向走到底，再回退，以此类推；BFS 则是按照“平推”的方式向前搜索。

**BFS 实现：** 通常利用队列实现广度优先遍历。

### 算法解析：

- **初始化：** 将机器人初始点 $(0, 0)$ 加入队列 `queue` ；
- **迭代终止条件：** `queue` 为空。代表已遍历完所有可达解。
- **迭代工作：**
  1. **单元格出队：** 将队首单元格的 索引、数位和 弹出，作为当前搜索单元格。
  2. **判断是否跳过：** 若 (1) 行列索引越界 **或** (2) 数位和超出目标值 `cnt`  **或** (3) 当前元素已访问过  时，执行 `continue` 。
  3. **标记当前单元格** ：将单元格索引 `(i, j)` 存入 Set `visited` 中，代表此单元格 **已被访问过** 。
  4. **单元格入队：** 将当前元素的 **下方、右方** 单元格的 **索引、数位和** 加入 `queue`  。
- **返回值：** Set `visited` 的长度 `len(visited)` ，即可达解的数量。

> Java/C++ 使用了辅助变量 `res` 统计可达解数量； Python 直接返回 Set 的元素数 `len(visited)` 即可。

<![Picture22.png](https://pic.leetcode-cn.com/1603024999-EKiknO-Picture22.png),![Picture23.png](https://pic.leetcode-cn.com/1603024999-hEnxrs-Picture23.png),![Picture24.png](https://pic.leetcode-cn.com/1603024999-goUtpL-Picture24.png),![Picture25.png](https://pic.leetcode-cn.com/1603024999-BwmmIl-Picture25.png),![Picture26.png](https://pic.leetcode-cn.com/1603024999-bQyxbG-Picture26.png),![Picture27.png](https://pic.leetcode-cn.com/1603024999-tjBCbi-Picture27.png),![Picture28.png](https://pic.leetcode-cn.com/1603024999-MBLwqu-Picture28.png),![Picture29.png](https://pic.leetcode-cn.com/1603024999-NYKszu-Picture29.png),![Picture30.png](https://pic.leetcode-cn.com/1603024999-aMYSTi-Picture30.png)>

### 代码：

> Java/C++ 代码中 `visited` 为辅助矩阵，Python 中为 Set 。

```Python []
class Solution:
    def wardrobeFinishing(self, m: int, n: int, cnt: int) -> int:
        queue, visited = [(0, 0, 0, 0)], set()
        while queue:
            i, j, si, sj = queue.pop(0)
            if i >= m or j >= n or cnt < si + sj or (i, j) in visited: continue
            visited.add((i,j))
            queue.append((i + 1, j, si + 1 if (i + 1) % 10 else si - 8, sj))
            queue.append((i, j + 1, si, sj + 1 if (j + 1) % 10 else sj - 8))
        return len(visited)
```

```Java []
class Solution {
    public int wardrobeFinishing(int m, int n, int cnt) {
        boolean[][] visited = new boolean[m][n];
        int res = 0;
        Queue<int[]> queue= new LinkedList<int[]>();
        queue.add(new int[] { 0, 0, 0, 0 });
        while(queue.size() > 0) {
            int[] x = queue.poll();
            int i = x[0], j = x[1], si = x[2], sj = x[3];
            if(i >= m || j >= n || cnt < si + sj || visited[i][j]) continue;
            visited[i][j] = true;
            res ++;
            queue.add(new int[] { i + 1, j, (i + 1) % 10 != 0 ? si + 1 : si - 8, sj });
            queue.add(new int[] { i, j + 1, si, (j + 1) % 10 != 0 ? sj + 1 : sj - 8 });
        }
        return res;
    }
}
```

```C++ []
class Solution {
public:
    int wardrobeFinishing(int m, int n, int cnt) {
        vector<vector<bool>> visited(m, vector<bool>(n, 0));
        int res = 0;
        queue<vector<int>> que;
        que.push({ 0, 0, 0, 0 });
        while(que.size() > 0) {
            vector<int> x = que.front();
            que.pop();
            int i = x[0], j = x[1], si = x[2], sj = x[3];
            if(i >= m || j >= n || cnt < si + sj || visited[i][j]) continue;
            visited[i][j] = true;
            res++;
            que.push({ i + 1, j, (i + 1) % 10 != 0 ? si + 1 : si - 8, sj });
            que.push({ i, j + 1, si, (j + 1) % 10 != 0 ? sj + 1 : sj - 8 });
        }
        return res;
    }
};
```

### 复杂度分析：

> 设矩阵行列数分别为 $M, N$ 。

- **时间复杂度 $O(MN)$ ：** 最差情况下，机器人遍历矩阵所有单元格，此时时间复杂度为 $O(MN)$ 。
- **空间复杂度 $O(MN)$ ：** 最差情况下，Set `visited` 内存储矩阵所有单元格的索引，使用 $O(MN)$ 的额外空间。
